#include <stdafx.h>
#include "SampleClasses.h"


Asteroid::Asteroid()
{
	set(0, 0, 0, 0);
}

void Asteroid::set(int x, int y, int type, int sf)
{
	m_x = x;
	m_y = y;
	m_type = type;
	m_sf = sf;
}


void Shot::set(int x, int y)
{
	m_x = x;
	m_y = y;
}

void GameStatus::clear(void)
{
	m_ship_present = false;
	m_saucer_present = false;
	m_nasteroids = 0;
	m_nshots = 0;
}


KeysPacket::KeysPacket(void)
{
	m_signature[0] = 'c';
	m_signature[1] = 't';
	m_signature[2] = 'm';
	m_signature[3] = 'a';
	m_signature[4] = 'm';
	m_signature[5] = 'e';
	m_keys = '@';
	m_ping = 0;
}

void KeysPacket::clear(void)
{
	m_keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		m_keys |= KEY_HYPERSPACE;
	else
		m_keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		m_keys |= KEY_FIRE;
	else
		m_keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		m_keys |= KEY_THRUST;
	else
		m_keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		m_keys |= KEY_LEFT;
		right(false);
	}
	else
		m_keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		m_keys |= KEY_RIGHT;
		left(false);
	}
	else
		m_keys &= ~KEY_RIGHT;
}

